﻿var fileManager = {
    context: $(".v-fileManager"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-filesTable", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getProjectAction("GetFiles", "FilesManager"),
            columns: [
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "FileExtention", "Title": resources.Type, "Data": "FileExtention" },
                { "Name": "Size", "Title": resources.FileSize, "Data": "Size", "Type": "numeric" },
                { "Name": "Modified", "Title": resources.LastModified, "Data": "Modified", "Type": "date" }
            ],
            localizableTexts: { "Search": resources.SearchFiles },
            stateKey: "ProjectFiles",
            allowRowSelection: true,
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "downloadAll", "Label": resources.Download }
            ],
            contextMenuItems: [
                { "Action": "download", "Label": resources.DownloadFile },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "import", "Label": resources.Imported, "DisplayCondition": function (data) { return data.FileType == 1 && data.FileExtention == 'lot'; } },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        fileManager.deleteFiles([row.Name], row.FileType);
                        break;
                    case "download":
                        fileManager.getFileData(row.Name, row.FileType);
                        break;
                    case "import":
                        fileManager.importLotFile(row.Name, row.FileType);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var names = _.pluck(rows, "Name");
                var fileType = rows[0].FileType;

                if (action == "delete") {
                    fileManager.deleteFiles(names, fileType);
                }
                else if (action == "downloadAll") {
                    fileManager.getFilesData(names, fileType);
                }
            },
            quickFilter: {
                "DisplayMode": "buttons",
                "IncludeAll": false,
                "Items": [{ "Label": resources.Imported, "AjaxParams": { "fileType": 1 } },
                        { "Label": resources.Exported, "AjaxParams": { "fileType": 0 } }]
            },
            draw: function () {
                $(".h-toolBarAction", fileManager.context).toggle($(".v-quickFilterButton.selected", fileManager.context).html() == resources.Imported);
            }
        });
    },
    bindEvents: function () {
        var options = { afterClose: function () { fileManager.refreshContent(); } };

        projectMenu.onAfterRefresh = function () {
            fileManager.refreshContent();
        };

        this.context.on("click", ".h-importFile", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportFileData", "FilesManager", { projectId: $("#ProjectId", fileManager.context).val() }), 260, 550, { afterClose: function () { fileManager.refreshContent(); } });
        });

        this.context.on("click", ".v-quickFilterButton", function () {
            $(".h-toolBarAction", fileManager.context).toggle($(this).html() == resources.Imported);
        });
    },
    deleteFiles: function (fileNames, fileType) {
        modalDialog.showConfirmDelete(confirmDeleteFilesResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteFiles", "FilesManager"), { fileNames: fileNames, fileType: fileType },
                function (result) {
                    fileManager.refreshContent();
                });
        }, fileNames.length);
    },
    getFilesData: function (fileNames, fileType) {
        window.location = a4.getProjectAction("GetFilesData", "FilesManager", { fileNamesJson: JSON.stringify(fileNames), fileType: fileType });
    },
    getFileData: function (fileName, fileType) {
        window.location = a4.getProjectAction("GetFileData", "FilesManager", { fileName: fileName, fileType: fileType });
    },
    importLotFile: function (fileName) {
        modalDialog.showConfirmDialog(confirmImportFilesResources, function () {
            a4.showBusyBox();
            a4.callServerMethod(a4.getProjectAction("ImportLotFile", "FilesManager"), { fileName: fileName },
                function (result) {
                    a4.hideBusyBox();
                    a4.showSuccessMessage(result, 3);
                    fileManager.refreshContent();
                });
        }, 250, 500, true, { "count": fileName.length });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    }
}

$(document).ready(function () {
    if (fileManager.context.length > 0)
    {
        fileManager.initializeDataTable();
        fileManager.bindEvents();
    }
});